<?php
ini_set('max_execution_time', '0');
// üöä UTF8-FTW
$all_counter = 0;
echo 'Desk rate limit log importer started ...'.PHP_EOL;

$mysqli = new mysqli('betterdesk-mysql.cunim1xnmwzu.us-west-1.rds.amazonaws.com', 'twitch_reports_write', 'QjghE4wuAN8CP55g', 'twitch_reports');
if($mysqli->connect_errno)
{
	echo 'Connection to database failed: '.$mysqli->connect_error;
	exit();
}
if(!$mysqli->set_charset('utf8mb4')) {
	printf("Error loading character set utf8mb4: %s\n", $mysqli->error);
	exit();
} else {
	printf("Current character set: %s\n", $mysqli->character_set_name());
}

echo 'Renaming log file ...'.PHP_EOL;
$get_file = 'rate_limit-'.time().'.log';
rename('/var/www/rate_limit.log', '/var/www/'.$get_file) or die('Couldn\'t rename file.'.PHP_EOL);

echo 'Sleeping 1 sec ...'.PHP_EOL;
sleep(1);

echo 'Starting log import ...'.PHP_EOL;
$sql_string = '';
$sql_counter = 0;
$handle = fopen('/var/www/'.$get_file, 'rb');
if($handle)
{
	while(!feof($handle))
	{
		$line = fgets($handle);
		$line_json_decode = json_decode($line, true);
		if($line_json_decode !== null && isset($line_json_decode['limit'], $line_json_decode['remaining'], $line_json_decode['reset'], $line_json_decode['date']))
		{
			$sql_string .= ",('".$mysqli->real_escape_string($line_json_decode['limit'])."','".$mysqli->real_escape_string($line_json_decode['remaining'])."','".$mysqli->real_escape_string($line_json_decode['reset'])."',FROM_UNIXTIME('".$mysqli->real_escape_string($line_json_decode['date'])."'))";
			$sql_counter++;

			echo '.';

			if($sql_counter >= 500)
			{
				// Inset into DB
				echo PHP_EOL.'Clearing buffer ...';
				$mysqli->query("INSERT INTO `desk_rate_limits` (`limit`, `remaining`, `reset`, `timestamp`) VALUES ".substr($sql_string, 1));
				echo ' done'.PHP_EOL;
				$sql_string = '';
				$sql_counter = 0;
				if(!empty($mysqli->errno))
				{
					echo $mysqli->errno . ': ' . $mysqli->error. PHP_EOL;
					exit();
				}
			}
			$all_counter++;
		}
	}
	fclose($handle);

	echo PHP_EOL.'Done with log import! ('.$all_counter.' added)'.PHP_EOL;

	// Clear "buffer" and insert it into the DB
	if(!empty($sql_string))
	{
		echo 'Clearing buffer ...';
		$mysqli->query("INSERT INTO `desk_rate_limits` (`limit`, `remaining`, `reset`, `timestamp`) VALUES ".substr($sql_string, 1));
		echo ' done'.PHP_EOL;
		$sql_string = '';
		$sql_counter = 0;
		if(!empty($mysqli->errno))
		{
			echo $mysqli->errno . ': ' . $mysqli->error. PHP_EOL;
			exit();
		}
	}

	// Delete imported log file
	unlink('/var/www/'.$get_file);
}
else
{
	echo 'Error while opening file!'.PHP_EOL;
}

echo 'Script is finished!'.PHP_EOL;

