$(document).ready(function() {
  // Click the button
  check_user_for_ban();
  // Sort the results
  $("#logstable").tablesorter({sortList: [[0,1]]});
});

function check_user_for_ban() {
  if($('#ban-check').val() != "") {
    $.getJSON('https://api.twitch.tv/kraken/users/' + encodeURIComponent($('#ban-check').val()) + '?client_id=' + twitch_kraken_client_id + '&callback=?').done(function (data) {
      if (/.+is unavailable$/.test(data.message)) { // Ban Check
        form_result('fail', 'Banned');
      } else if (/.+is not available on Twitch$/.test(data.message) || /.+does not exist$/.test(data.message)) { // JTV / Nonexistant Check
        form_result('warn', 'JTV or Deleted');
      } else {
        form_result('success', 'OK');
      }
    }).fail(function () {
      form_result('warn', 'The Twitch API appears to have returned an invalid response. Twitch may be having issues at the moment.')
    })
  }
}

function form_result(type, message) {
  if (type === 'success') {
    var style = 'class="label label-success"';
  } else if (type === 'warn') {
    var style = 'class="label label-info"';
  } else {
    var style = 'class="label label-danger" style="background-color: #D9534F;"';
  }

  $('#ban-check-result').html('<span ' + style + '>' + message + '</span>');
}

function clear_ban_check_result() {
  $('#ban-check-result').html('');
}

function translate_popup(url) {
  var popup_window = window.open(url, "Translate_popup_chatlogs_" + Date.now(), "width=865,height=475,resizable=yes");
  popup_window.focus();
  return false;
}
