function resolve_email(email_id) {
  $.ajax({
    url: "/emails/" + email_id,
    type: "PATCH",
    timeout: 10000, // sets timeout to 10 seconds
    data: { do_action: "resolve", authenticity_token: $("meta[name=csrf-token]").attr("content") },
    success: function(result, textStatus, jqXHR) {
      $("#assign_and_resolve_" + email_id).html("Email resolved.");
    },
    error: function(jqXHR, textStatus, errorThrown) {
      // Try again
      $("#assign_and_resolve_" + email_id).html(errorThrown + '... Try again');
      $("#assign_and_resolve_" + email_id).removeAttr('disabled');
    }
  });

  $("#assign_and_resolve_" + email_id).html('Resolving ...');
  $("#assign_and_resolve_" + email_id).attr("disabled", "disabled");

  // Disable other button
  $("#assign_to_staff_" + email_id).attr("disabled", "disabled");
}

function assign_to_staff(email_id) {
  $.ajax({
    url: "/emails/" + email_id,
    type: "PATCH",
    timeout: 10000, // sets timeout to 10 seconds
    data: { do_action: "assign_to_staff", authenticity_token: $("meta[name=csrf-token]").attr("content") },
    success: function(result, textStatus, jqXHR) {
      $("#assign_to_staff_" + email_id).html("Email assigned to staff.");
    },
    error: function(jqXHR, textStatus, errorThrown) {
      // Try again
      $("#assign_to_staff_" + email_id).html(errorThrown + '... Try again');
      $("#assign_to_staff_" + email_id).removeAttr('disabled');
    }
  });

  $("#assign_to_staff_" + email_id).html('Assigning ...');
  $("#assign_to_staff_" + email_id).attr("disabled", "disabled");

  // Disable other button
  $("#assign_and_resolve_" + email_id).attr("disabled", "disabled");
}

function show_reply_area() {
  $("#reply_area").css({"display": "block"});
}
