class AltLookupController < ApplicationController
  # Let only people with use_alt_lookup permission do stuff
  before_action :require_use_alt_lookup_permission
  # Let only people with view_alt_lookup_audits view audits
  before_action :require_view_alt_lookup_audits, only: [:audits]


  def index
    if params[:username] && !params[:username].blank?
      # Get the user ID from the username
      begin
        user_id = ::TwitchUsersService.get_user_by_username(params[:username].downcase.strip)

        if user_id.nil?
          flash.now[:danger] = "Username not found"
          render 'index' and return
        end

        user_id = user_id["id"] unless user_id.nil?
      rescue Exception => e
        flash.now[:danger] = e.message
        render 'index' and return
      end

      # Do the api request
      begin
          url = URI.parse("http://altlookup.moderation.twitch.tv/v1/alts?user_id=#{user_id}")
          http = Net::HTTP.new(url.host, url.port)
          http.use_ssl = true if url.scheme == "https"
          http.open_timeout = 2
          http.read_timeout = 30
          req = Net::HTTP::Get.new(url.request_uri)
          res = http.request(req)

          unless res.is_a?(Net::HTTPSuccess)
            flash.now[:danger] = "There was an issue checking alts."
            render 'index' and return
          end

        rescue Exception => e
          flash.now[:danger] = "There was an issue with the alt lookup backend, maybe this user has too many alts."
          render 'index' and return
      end

      @alts = JSON.parse(res.body)

      # Generate the login list for chat activity check
      @login_list = []
      @alts.each do |alt|
        @login_list << alt["Login"]
      end

      ## Audit it
      AltLookupAudit.new(action: "lookup", action_by: current_user.id, command: params[:username].downcase.strip).save

    end
  end

  def audits
    @alt_lookup_audits = AltLookupAudit.order(id: :desc).paginate(page: params[:page])
  end


  private

    def require_use_alt_lookup_permission
      unless current_user && current_user.has_permission_to?(:use_alt_lookup)
        render 'shared/_no_permission' and return
      end
    end

    def require_view_alt_lookup_audits
      unless current_user && current_user.has_permission_to?(:view_alt_lookup_audits)
        render 'shared/_no_permission' and return
      end
    end
end
