class ApplicationController < ActionController::Base
  # Prevent CSRF attacks by raising an exception.
  # For APIs, you may want to use :null_session instead.
  protect_from_forgery with: :exception
  helper_method :current_user
  before_action :require_login


  def current_user
    @current_user ||= User.eager_load(:permission).find_by(id: session[:user_id], enabled: true) if session[:user_id]
  end

  # Stores the URL trying to be accessed.
  def store_location
    session[:forwarding_url] = request.url if request.get?
  end


  private

    def require_login
      unless current_user
        flash[:danger] = "Please log in to use this part of the site."
        store_location
        redirect_to root_path
      end
    end
end
