class ChatlogsController < ApplicationController
  before_action :require_view_chatlogs_permission
  before_action :require_delete_chatlogs_permission, only: [:delete, :audits]

  def index
    client = Mysql2::Client.new(
      host: ENV['CHATLOGS_DB_HOST'],
      username: ENV['CHATLOGS_DB_USER'],
      password: ENV['CHATLOGS_DB_PW'],
      database: ENV['CHATLOGS_DB_DATABASE'],
      encoding: "utf8mb4"
    )

    if current_user.has_permission_to?(:view_all_chatlogs)
      display_table_count = -1
    else
      display_table_count = 14
    end

    @available_tables = []
    result = client.query("SHOW TABLES FROM `" + ENV['CHATLOGS_DB_DATABASE'] + "` LIKE '" + ENV['CHATLOGS_DB_TABLE_PREFIX'] + "%'", as: :array)
    table_prefix_length = ENV['CHATLOGS_DB_TABLE_PREFIX'].length
    result.each do |row|
      @available_tables << row[0].to_s[table_prefix_length..-1]
    end
    @available_tables.reverse!

    # Remove the additional tables we don't want to see
    if display_table_count > 0
      @available_tables = @available_tables[0, display_table_count]
    end

    # Check if we want to delete old tables
    if @available_tables.size > ENV['CHATLOGS_DB_KEEP_DAYS'].to_i
      remove_old_tables()
    end

    # Default table to the latest if not set
    params["table"] = @available_tables[0] if (!params["table"] || params["table"].blank?) && !@available_tables.empty?

    chatlogs_query_string = ''
    if ((params["room"] && !params["room"].blank?) || (params["room_id"] && !params["room_id"].blank?) || (params["username"] && !params["username"].blank?) || (params["user_id"] && !params["user_id"].blank?)) && params["table"] && !params["table"].blank? && @available_tables.include?(params["table"])
      if params["all"] && params["all"] == "all" && params["username"] && !params["username"].blank?
        chatlog_table_foreach_counter = 0
        @available_tables.each do |table|
          chatlogs_query_string = chatlogs_query_string + "(SELECT `ID`,`room`,`room_id`,`nick`,`nick_id`,`message`,`tags_int`,UNIX_TIMESTAMP(`timestamp`) as `timestamp`,'#{table}' as `table` FROM `#{ENV['CHATLOGS_DB_TABLE_PREFIX']}#{table}` WHERE `nick` = '#{client.escape(params['username'])}' ORDER BY `ID` DESC) UNION ALL "
          chatlog_table_foreach_counter = chatlog_table_foreach_counter + 1
          if chatlog_table_foreach_counter >= 30
            # This limits the all lookup to the last 30 days / tables max
            break
          end
        end

        chatlogs_query_string = chatlogs_query_string[0, chatlogs_query_string.length-11] # To remove the UNION ALL at the end
      elsif params["all"] && params["all"] == "all" && params["user_id"] && !params["user_id"].blank?
        chatlog_table_foreach_counter = 0
        @available_tables.each do |table|
          chatlogs_query_string = chatlogs_query_string + "(SELECT `ID`,`room`,`room_id`,`nick`,`nick_id`,`message`,`tags_int`,UNIX_TIMESTAMP(`timestamp`) as `timestamp`,'#{table}' as `table` FROM `#{ENV['CHATLOGS_DB_TABLE_PREFIX']}#{table}` WHERE `nick_id` = '#{client.escape(params['user_id'])}' ORDER BY `ID` DESC) UNION ALL "
          chatlog_table_foreach_counter = chatlog_table_foreach_counter + 1
          if chatlog_table_foreach_counter >= 30
            # This limits the all lookup to the last 30 days / tables max
            break
          end
        end

        chatlogs_query_string = chatlogs_query_string[0, chatlogs_query_string.length-11] # To remove the UNION ALL at the end
      else
        chatlogs_query_string = chatlogs_query_string + "SELECT `ID`,`room`,`room_id`,`nick`,`nick_id`,`message`,`tags_int`,UNIX_TIMESTAMP(`timestamp`) as `timestamp`,'#{client.escape(params['table'])}' as `table` FROM `#{ENV['CHATLOGS_DB_TABLE_PREFIX']}#{client.escape(params['table'])}` WHERE "

        if params["room"] && !params["room"].blank?
          chatlogs_query_string = chatlogs_query_string + "`room` = '\##{client.escape(params['room'])}'"
          if params["mods_only"] && !params["mods_only"].blank?
            chatlogs_query_string = chatlogs_query_string + ' AND `tags_int`&1 = 1'
          end
        elsif params["room_id"] && !params["room_id"].blank?
          chatlogs_query_string = chatlogs_query_string + "`room_id` = '#{client.escape(params['room_id'])}'"
          if params["mods_only"] && !params["mods_only"].blank?
            chatlogs_query_string = chatlogs_query_string + ' AND `tags_int`&1 = 1'
          end
        elsif params["username"] && !params["username"].blank?
          chatlogs_query_string = chatlogs_query_string + "`nick` = '#{client.escape(params['username'])}'"
        elsif params["user_id"] && !params["user_id"].blank?
          chatlogs_query_string = chatlogs_query_string + "`nick_id` = '#{client.escape(params['user_id'])}'"
        end

        if params["message"] && !params["message"].blank?
          chatlogs_query_string = chatlogs_query_string + " AND `message` REGEXP '#{client.escape(params['message'])}'"
        end

        if params["unique_names"] && params["unique_names"] == "true"
          chatlogs_query_string = chatlogs_query_string + ' GROUP BY `nick`'
        end

        chatlogs_query_string = chatlogs_query_string + ' ORDER BY `ID` DESC'
      end
    elsif params["message"] && !params["message"].blank? && params["table"] && !params["table"].blank? && @available_tables.include?(params["table"])
      chatlogs_query_string = chatlogs_query_string + "SELECT `ID`,`room`,`room_id`,`nick`,`nick_id`,`message`,`tags_int`,UNIX_TIMESTAMP(`timestamp`) as `timestamp`,'#{client.escape(params['table'])}' as `table` FROM `#{ENV['CHATLOGS_DB_TABLE_PREFIX']}#{client.escape(params['table'])}` WHERE `message` REGEXP '#{client.escape(params['message'])}'"

      if params["unique_names"] && params["unique_names"] == "true"
        chatlogs_query_string = chatlogs_query_string + ' GROUP BY `nick`'
      end

      chatlogs_query_string = chatlogs_query_string + ' ORDER BY `ID` DESC'
    end

    if !chatlogs_query_string.blank?
      @chatlog_lines = client.query(chatlogs_query_string, :symbolize_keys => true)

      # Audit it
      ChatlogsAudit.new(action: "search", action_by: current_user.id, command: request.query_parameters.delete_if{ |k, v| v.empty? }.to_json).save
    end

  end

  def audits
    @chatlogs_audits = ChatlogsAudit.order(id: :desc).paginate(page: params[:page])
  end

  def chat_activity
    if request.post? && params[:list] && !params[:list].blank?
      client = Mysql2::Client.new(
        host: ENV['CHATLOGS_DB_HOST'],
        username: ENV['CHATLOGS_DB_USER'],
        password: ENV['CHATLOGS_DB_PW'],
        database: ENV['CHATLOGS_DB_DATABASE'],
        encoding: "utf8mb4"
      )

      # Parse the list to get all usernames
      list = params[:list].gsub(/\t/, " ").gsub(/ /, " ")
      list_lines = list.split("\n")

      index = 0
      while true
        unless list_lines[index]
         # Exit out if we are at the end of the array
          break
        end

        list_lines[index] = list_lines[index].strip
        if list_lines[index].blank?
          list_lines.delete_at(index)
        else
          index = index + 1
        end
      end

      # Remove duplicate lines
      list_lines = list_lines.uniq

      # Parse the list
      not_lookup_user_array = %w(xanbot nightbot moobot ackbot login)
      @user_list = []
      list_lines.each do |list_part|
        list_part_exploded = list_part.split(" ")
        # If it ends with View the it's for sure an AA lookup
        if list_part_exploded.size >= 2 && list_part[-4..-1] == 'View'
          part_username = list_part_exploded[2]
        elsif list_part_exploded[0].match(/\A\d+\Z/) && list_part_exploded[2] && !list_part_exploded[2].blank? && !%w(Type login ip email).include?(list_part_exploded[2])
          # Still AA lookup
          part_username = list_part_exploded[2]
        else
          # Normal list or Alt Lookup room
          part_username = list_part_exploded[0]
        end

        if !not_lookup_user_array.include?(part_username.downcase)
          @user_list << part_username.downcase
        end
      end

      # Remove duplicate users
      @user_list = @user_list.uniq

      if @user_list.size > 2500
        flash.now[:danger] = "You can only check up to 2500 users at once"
        return
      elsif @user_list.size > 0
        available_tables = []
        result = client.query("SHOW TABLES FROM `" + ENV['CHATLOGS_DB_DATABASE'] + "` LIKE '" + ENV['CHATLOGS_DB_TABLE_PREFIX'] + "%'", as: :array)
        result.each do |row|
          available_tables << row[0].to_s
        end
        available_tables.reverse!

        # Limit to the last 2 days / tables
        available_tables = available_tables[0, 2]

        chatlogs_query_string = ''
        available_tables.each do |table|
          chatlogs_query_string += "(SELECT `room`,`nick`, CASE WHEN `tags_int`&1 = 1 THEN 'MOD' ELSE '' END `mod` FROM `#{client.escape(table)}` WHERE `nick` IN (#{array_to_sql_string(@user_list)}) AND `tags_int`&128 != 128) UNION DISTINCT "
        end

        chatlogs_query_string = chatlogs_query_string[0..-16]
        chatlogs_query_string += ' ORDER BY `room` ASC, `nick` ASC'
      end

      # Do the actual query
      @active_chatter = ""
      db_result = client.query(chatlogs_query_string, :symbolize_keys => true)
      db_result.each do |row|
        user_in_channel_status = ""
        if row[:mod] == "MOD"
          user_in_channel_status = " [MOD]"
        end
        @active_chatter += "#{row[:room]}     #{row[:nick]}#{user_in_channel_status}\r\n"
      end

      # Remove the last new line
      @active_chatter = @active_chatter.strip
    end
  end

  def delete
    client = Mysql2::Client.new(
      host: ENV['CHATLOGS_DB_HOST'],
      username: ENV['CHATLOGS_DB_USER'],
      password: ENV['CHATLOGS_DB_PW'],
      database: ENV['CHATLOGS_DB_DATABASE'],
      encoding: "utf8mb4"
    )

    available_tables = []
    result = client.query("SHOW TABLES FROM `" + ENV['CHATLOGS_DB_DATABASE'] + "` LIKE '" + ENV['CHATLOGS_DB_TABLE_PREFIX'] + "%'", as: :array)
    table_prefix_length = ENV['CHATLOGS_DB_TABLE_PREFIX'].length
    result.each do |row|
      available_tables << row[0].to_s[table_prefix_length..-1]
    end

    # check if the params table is within the available tables
    if params["table"] && !params["table"].blank? && available_tables.include?(params["table"])
      if params["id"] && !params["id"].blank?
        # Check if this ID still exists in the DB
        result = client.query("SELECT `ID` FROM `#{ENV['CHATLOGS_DB_TABLE_PREFIX']}#{client.escape(params['table'])}` WHERE `ID` = '#{client.escape(params['id'])}'")
        if result.count > 0
          # Delete it
          client.query("DELETE FROM `#{ENV['CHATLOGS_DB_TABLE_PREFIX']}#{client.escape(params['table'])}` WHERE `ID` = '#{client.escape(params['id'])}'")

          # Audit the delete
          ChatlogsAudit.new(action: "delete", action_by: current_user.id, command: request.query_parameters.delete_if{ |k, v| v.empty? }.to_json).save

          flash[:success] = "The line was successfully deleted."
        else
          flash[:danger] = "This line doesn't even exist anymore."
        end
      else
        flash[:danger] = "No chat line selected."
      end
    else
      flash[:danger] = "This table doesn't exist."
    end

    if params[:org_req_params]
      redirect_to(chatlogs_path(params: params[:org_req_params]))
    else
      redirect_to(chatlogs_path)
    end
  end

  private

    def require_view_chatlogs_permission
      unless current_user && current_user.has_permission_to?(:view_chatlogs)
        render 'shared/_no_permission' and return
      end
    end

    def require_delete_chatlogs_permission
      unless current_user && current_user.has_permission_to?(:delete_chatlogs)
        flash[:danger] = "You don't have permissions to delete chatlog lines."
        redirect_to(chatlogs_path) and return
      end
    end

    def array_to_sql_string(array)
      if array.size > 0
        string = ""
        array.each do |part|
          string += ",'#{Mysql2::Client.escape(part)}'"
        end

        return string[1..-1]
      else
        return "''"
      end
    end

    def remove_old_tables
      client = Mysql2::Client.new(
        host: ENV['CHATLOGS_DB_HOST'],
        username: ENV['CHATLOGS_DB_USER'],
        password: ENV['CHATLOGS_DB_PW'],
        database: ENV['CHATLOGS_DB_DATABASE'],
        encoding: "utf8mb4"
      )

      existing_tables = []
      result = client.query("SHOW TABLES FROM `" + ENV['CHATLOGS_DB_DATABASE'] + "` LIKE '" + ENV['CHATLOGS_DB_TABLE_PREFIX'] + "%'", as: :array)
      result.each do |row|
        existing_tables << row[0]
      end
      existing_tables.reverse!

      tables_to_delete = []
      if existing_tables.size > ENV['CHATLOGS_DB_KEEP_DAYS'].to_i
        tables_to_delete = existing_tables[ENV['CHATLOGS_DB_KEEP_DAYS'].to_i..-1]
      end

      if tables_to_delete.size > 0
        client.query("DROP TABLE IF EXISTS `#{tables_to_delete.join("`,`")}`")

        # Audit the table drop
        ChatlogsAudit.new(action: "drop_table", command: tables_to_delete.to_json).save
      end
    end
end
