class ClipsOverviewController < ApplicationController
  def index
    if params[:channel] && !params[:channel].blank?
      if params[:mode] && params[:mode] == "similar"
        @clips = get_similar_clips_for_channel(params[:channel], params[:slug])
      elsif params[:mode] && params[:mode] == "timestamp"
        @clips = get_timestamp_clips_for_channel(params[:channel], params[:timestamp])
      else
        @next_cursor = ""
        cursor = params[:cursor] ? params[:cursor] : ""
        @clips = get_clips_for_channel(params[:channel], cursor)
      end
    end
  end


  private

    def get_clips_for_channel(channel, cursor)
      clips_array = []
      request_url = "https://clips.twitch.tv/api/v1/channels/#{URI::escape(channel.downcase.strip)}?limit=250&_=#{Time.now.to_i}"
      unless cursor.blank?
        request_url = "#{request_url}&cursor=#{URI::escape(cursor)}"
      end

      url = URI.parse(request_url)
      http = Net::HTTP.new(url.host, url.port)
      http.use_ssl = true
      http.open_timeout = 2
      http.read_timeout = 15
      req = Net::HTTP::Get.new(url.request_uri)
      res = http.request(req)

      unless res.is_a?(Net::HTTPSuccess)
        if res.is_a?(Net::HTTPNotFound)
          raise "Not found"
        end

        raise "Twitch API error"
      end

      res_hash = JSON.parse(res.body)
      # logger.debug "res_hash: #{res_hash.to_s}" if Rails.env.development?
      @next_cursor = res_hash["cursor"]

      if !res_hash["clips"].nil? && res_hash["clips"].size > 0
        clips_array = res_hash["clips"]
      end

      return clips_array
    end

    def get_similar_clips_for_channel(channel, slug)
      temp_clips_array = []
      clips_array = []
      timespan = 10 * 60 # Seconds we want to look for clips before and after the provided timestamp
      timestamp = 0
      found_end = false

      org_request_url = "https://clips.twitch.tv/api/v1/channels/#{URI::escape(channel.downcase.strip)}?limit=1000"
      request_url = "#{org_request_url}&_=#{Time.now.to_i}"
      while found_end == false do
        url = URI.parse(request_url)
        http = Net::HTTP.new(url.host, url.port)
        http.use_ssl = true
        http.open_timeout = 2
        http.read_timeout = 15
        req = Net::HTTP::Get.new(url.request_uri)
        res = http.request(req)

        unless res.is_a?(Net::HTTPSuccess)
          if res.is_a?(Net::HTTPNotFound)
            raise "Not found"
          end

          raise "Twitch API error"
        end

        res_hash = JSON.parse(res.body)
        # logger.debug "res_hash: #{res_hash.to_s}" if Rails.env.development?
        if res_hash["clips"].nil? || res_hash["clips"].size == 0
          found_end = true
        else
          res_hash["clips"].each do |clip|
            if !slug.blank? && clip["clip_url"].include?(slug)
              # Found our start clip
              timestamp = Time.parse(clip["created_at"]).to_i
            end

            if timestamp > 0 && Time.parse(clip["created_at"]).to_i <= (timestamp - timespan)
              # The clip is older than we need
              found_end = true
            else
              temp_clips_array << clip
            end
          end

          if res_hash["cursor"] && !res_hash["cursor"].blank?
            request_url = "#{org_request_url}&cursor=#{URI::escape(res_hash["cursor"])}&_=#{Time.now.to_i}"
          else
            found_end = true
          end
        end
      end

      # Clean our results (basically remove all the stuff newer than we want)
      if temp_clips_array.size > 0 && timestamp > 0
        temp_clips_array.each do |clip|
          if Time.parse(clip["created_at"]).to_i >= (timestamp.to_i + timespan)
            # The clip is newer than we need
          elsif Time.parse(clip["created_at"]).to_i <= (timestamp.to_i - timespan)
            # The clip is older than we need
          else
            clips_array << clip
          end
        end
      end

      return clips_array
    end

    def get_timestamp_clips_for_channel(channel, timestamp)
      clips_array = []
      timespan = 10 * 60 # Seconds we want to look for clips before and after the provided timestamp
      found_end = false

      org_request_url = "https://clips.twitch.tv/api/v1/channels/#{URI::escape(channel.downcase.strip)}?limit=1000"
      request_url = "#{org_request_url}&_=#{Time.now.to_i}"
      while found_end == false do
        url = URI.parse(request_url)
        http = Net::HTTP.new(url.host, url.port)
        http.use_ssl = true
        http.open_timeout = 2
        http.read_timeout = 15
        req = Net::HTTP::Get.new(url.request_uri)
        res = http.request(req)

        unless res.is_a?(Net::HTTPSuccess)
          if res.is_a?(Net::HTTPNotFound)
            raise "Not found"
          end

          raise "Twitch API error"
        end

        res_hash = JSON.parse(res.body)
        # logger.debug "res_hash: #{res_hash.to_s}" if Rails.env.development?
        if res_hash["clips"].nil? || res_hash["clips"].size == 0
          found_end = true
        else
          res_hash["clips"].each do |clip|
            if Time.parse(clip["created_at"]).to_i >= (timestamp.to_i + timespan)
              # The clip is newer than we need
            elsif Time.parse(clip["created_at"]).to_i <= (timestamp.to_i - timespan)
              # The clip is older than we need
              found_end = true
            else
              clips_array << clip
            end
          end

          if res_hash["cursor"] && !res_hash["cursor"].blank?
            request_url = "#{org_request_url}&cursor=#{URI::escape(res_hash["cursor"])}&_=#{Time.now.to_i}"
          else
            found_end = true
          end
        end
      end

      return clips_array
    end
end
