class SessionsController < ApplicationController
  skip_before_action :require_login, only: [:index, :create, :failure]

  def create
    user = User.from_omniauth(env["omniauth.auth"])
    if user
      if user.enabled == true
        session[:user_id] = user.id
        flash[:success] = "You successfully logged in. Welcome #{user.email}"

        # Audit it
        UserAudit.new(user_id: user.id, action: "login", action_by: user.id, remote_ip: request.remote_ip).save

        redirect_back_or(root_path)
        return
       else
        flash[:warning] = "Your account is not activated yet. Please contact a moderation staff member."
      end
    else
      flash[:danger] = "You are not allowed to login here. Please use your work email instead."
    end
    redirect_to(root_path) and return
  end

  def destroy
    # Audit it
    if current_user
      UserAudit.new(user_id: current_user.id, action: "logout", action_by: current_user.id, remote_ip: request.remote_ip).save
    end

    session[:user_id] = nil
    @current_user = nil
    redirect_to(root_path) and return
  end

  def index
    if current_user
      render 'overview' and return
    end
  end

  def failure
    failure = params[:message] if params[:message]
    if failure
      if failure == "invalid_credentials"
        flash[:danger] = "You can't login with this account. This page is restricted to Twitch accounts."
      else
        flash[:danger] = "There was an unknown issue logging in, please try again later."
      end
    end
    redirect_to(root_path) and return
  end


  # Redirects to stored location (or to the default).
  def redirect_back_or(default)
    redirect_to(session[:forwarding_url] || default)
    session.delete(:forwarding_url)
  end
end
