class UsersController < ApplicationController
  def index
    if current_user && current_user.has_permission_to?(:edit_user)
      @users = User.order(email: :asc).paginate(page: params[:page])
    else
      render 'shared/_no_permission' and return
    end
  end

  def edit
    if current_user && (current_user.has_permission_to?(:edit_user) || (params[:id] && current_user.id == params[:id].to_i))
      @user = User.find(params[:id])
      @user.permission if current_user.has_permission_to?(:edit_user)
    else
      render 'shared/_no_permission' and return
    end
  end

  def update
    if current_user && current_user.has_permission_to?(:edit_user)
      @user = User.find(params[:id])
      @user.permission
      org_user = @user.dup
      org_user.permission = @user.permission.dup

      if @user.update_attributes(user_params_admin)
        # Audit it
        if !org_user.diff(@user).blank?
          UserAudit.new(
            user_id: @user.id,
            action: "user_properties_change",
            action_by: current_user.id,
            diff: org_user.diff(@user).to_json,
            remote_ip: request.remote_ip
          ).save
        end

        if @user.permission.update_attributes(permission_params)
          # Audit it
          if !org_user.permission.diff(@user.permission).blank?
            UserAudit.new(user_id: @user.id,
              action: "user_permission_change",
              action_by: current_user.id,
              diff: org_user.permission.diff(@user.permission).to_json,
              remote_ip: request.remote_ip
            ).save
          end

          flash[:success] = "User successfully updated."
          redirect_to(edit_user_path(@user))
        else
          render 'edit'
        end
      else
        render 'edit'
      end
    elsif current_user && params[:id] && current_user.id == params[:id].to_i
      @user = User.find(params[:id])
      org_user = @user.dup

      if @user.update_attributes(user_params_account_owner)
        # Audit it
        if !org_user.diff(@user).blank?
          UserAudit.new(
            user_id: @user.id,
            action: "user_properties_change",
            action_by: current_user.id,
            diff: org_user.diff(@user).to_json,
            remote_ip: request.remote_ip
          ).save
        end

        flash[:success] = "Settings successfully updated."
        redirect_to(edit_user_path(@user))
      else
        render 'edit'
      end
    else
      render 'shared/_no_permission' and return
    end
  end

  def audits
    if current_user && current_user.has_permission_to?(:edit_user)
      @user_audits = UserAudit.where(user_id: params[:id]).order(id: :desc).paginate(page: params[:page])
      @user_id = params[:id]
    else
      render 'shared/_no_permission' and return
    end
  end

  def search
    if current_user && current_user.has_permission_to?(:edit_user)
      conditions = user_search_params.delete_if {|k,v| v.blank? }
      if conditions[:users]
        conditions[:users] = conditions[:users].delete_if {|k,v| v.blank? }
      end

      if conditions[:users] && conditions[:users].any?
        @users = User.where(conditions).order(id: :asc).paginate(page: params[:page])
      end
    else
      render 'shared/_no_permission' and return
    end
  end

  private

    def user_params_admin
      params.require(:user).permit(:twitch_id, :enabled,
                                  :report_mode, :report_sound_notification, :style)
    end

    def user_params_account_owner
      params.require(:user).permit(:report_mode, :report_sound_notification, :style)
    end

    def user_search_params
      params.permit(
        users: [
          :id,
          :email,
          :enabled
        ]
      ).to_h
    end

    def permission_params
      params.require(:permission).permit(
        :edit_user,
        :view_reports,
        :view_chatlogs,
        :delete_chatlogs,
        :delete_file_uploads,
        :view_file_uploads_audits,
        :manage_ban_exceptions,
        :view_alt_lookup_audits,
        :manage_suspension_guide,
        :view_emails,
        :view_email_audits,
        :view_report_admin_history,
        :use_alt_lookup,
        :use_janitor,
        :view_janitor_audits,
        :counter_check_suspensions,
        :view_all_chatlogs
      )
    end
end
