class SpadeRequestJob < ActiveJob::Base
  queue_as :default

  def perform(json, try_counter = 0)
    # Base64 encode the json
    request_load = Base64.encode64(json)

    max_tries = 5
    request_succeeded = false

    # Send the data to spade
    begin
        try_counter = try_counter + 1

        url = URI.parse("https://spade.internal.justin.tv/?data=#{request_load}")
        http = Net::HTTP.new(url.host, url.port)
        http.use_ssl = true if url.scheme == "https"
        http.open_timeout = 1
        http.read_timeout = 3
        req = Net::HTTP::Get.new(url.request_uri)
        res = http.request(req)

        if res.is_a?(Net::HTTPSuccess)
          request_succeeded = true
        else
          logger.debug "SpadeRequestJob HTTP error on try #{try_counter}: #{res.code}"
        end
      rescue Exception => e
        logger.debug "SpadeRequestJob Exception on try #{try_counter}: #{e.message}"
    end

    # Add it to the queue again if it failed and is within the max_tries limit
    if request_succeeded != true && try_counter < max_tries
      SpadeRequestJob.set(wait: 5.seconds).perform_later(json, try_counter)
    end
  end
end
