class SuspensionRetryJob < ActiveJob::Base
  queue_as :default

  def perform(json)
    # Send the data to spade
    begin
        url = URI.parse("http://localhost:3000/suspensions")
        http = Net::HTTP.new(url.host, url.port)
        http.use_ssl = true if url.scheme == "https"
        http.open_timeout = 1
        http.read_timeout = 5
        req = Net::HTTP::Post.new(url.request_uri)
        req.add_field("Content-Type", "application/json")
        req.body = json
        res = http.request(req)

        unless res.is_a?(Net::HTTPSuccess)
          logger.debug "SuspensionRetryJob HTTP error: #{res.code}"
        end
      rescue Exception => e
        logger.debug "SuspensionRetryJob Exception: #{e.message}"
    end
  end
end
