require 'zlib'

class ConsistentHashr

  ##
  # Creates a new Hasher.
  def initialize()
    @number_of_replicas = 256
    @circle = {}
    @admins = {}
    @overall_weight = 0
  end

  ##
  # Computes a key
  def hash_key(key)
    # SHA256 it first to make sure similar keys are spaced more random
    Zlib.crc32(Digest::SHA256.hexdigest("#{key}"))
  end

  ##
  # Adds an admin to the module
  def add_admin(_admin, _weight = 10)
    @admins[_admin] = _weight
    @overall_weight = @overall_weight + _weight
  end

  ##
  # Calculates the circles based on the currently added admins and their weight
  def calculate_circles()
    return nil if @admins.size == 0
    avg_weight = @overall_weight.to_f / @admins.size.to_f
    @admins.each do |admin,weight|
      weighted_replicas = ((weight / avg_weight) * @number_of_replicas).round
      weighted_replicas.times do |t|
        @circle[hash_key("#{admin}+#{t}")] = admin
      end
    end
  end

  ##
  # Resets the module aka removes all current admins
  def reset()
    @circle = {}
    @admins = {}
    @overall_weight = 0
  end

  ##
  # Returns the admin for the provided key
  def map(key)
    return nil if @circle.empty?
    return @circle.first.last if @circle.size == 1

    hash = hash_key(key)

    # If the key is there, let's return it.
    return @circle[hash] if @circle[hash]

    # If not, we need to find the next closest from it!
    hash = @circle.keys.select() { |k| k > hash }.sort.first

    return @circle.first.last if hash.nil?
    return @circle[hash]
  end

end