require 'active_record/diff'

class Suspension < ActiveRecord::Base
  include ActiveRecord::Diff
  diff :exclude => [:created_at, :updated_at]

  validates :from_user_id, presence: true
  validates :from_user_type, presence: true, inclusion: { in: %w(admin staff ldap) }

  validates :target_user_username, presence: true, format: { with: /\A[a-z0-9_]+\z/ }
  validates :target_user_id, presence: true, numericality: { only_integer: true }
  validates :target_user_type, presence: true, inclusion: { in: %w(user global_mod admin staff) }
  validates :target_user_partner, inclusion: { in: [true, false] }

  validates :reason, presence: true, inclusion: { in: %w(bits_violation chat_ban_evasion cheating creative_conduct gore harassment harm hate_speech impersonation music_conduct nongaming offensive_username other porn prohibited selfharm social_eating_violation spam tos_ban_evasion underaged) }

  validates :duration, presence: true, numericality: { only_integer: true }
  validates :ip_ban, numericality: { only_integer: true }
  validates :cleared_channel_images, inclusion: { in: [true, false] }

  validates :origin, presence: true

end
