require 'active_record/diff'

class SuspensionGuideContent < ActiveRecord::Base
  include ActiveRecord::Diff
  diff :exclude => [:created_at, :updated_at]

  before_save { self.content = content.downcase.strip }
  before_save { self.content_description = content_description.strip }
  validates :content, presence: true, uniqueness: { case_sensitive: false }, format: { with: /\A[a-z0-9_]+\z/ }
  validates :content_description, presence: true

end
