require 'active_record/diff'

class SuspensionGuideDetailedReason < ActiveRecord::Base
  include ActiveRecord::Diff
  diff :exclude => [:created_at, :updated_at]

  before_save { self.detailed_reason = detailed_reason.downcase.strip }
  validates :detailed_reason, presence: true, uniqueness: { case_sensitive: false }, format: { with: /\A[a-z0-9_]+\z/ }

end
