require 'net/http'

class TwitchVinylService

  def self.get_currently_recording_vod(channel_id)
   if channel_id.blank?
      return nil
    end

    api_offset = 0
    # Do the api request
    url = URI.parse("http://vinyl-internal.production.us-west2.twitch.tv/v1/vods/user/#{channel_id}?broadcast_type=archive&limit=100&offset=#{api_offset}")
    http = Net::HTTP.new(url.host, url.port)
    http.use_ssl = true if url.scheme == "https"
    http.open_timeout = 1
    http.read_timeout = 5
    req = Net::HTTP::Get.new(url.request_uri)
    res = http.request(req)

    unless res.is_a?(Net::HTTPSuccess)
      raise "Twitch API error"
    end

    current_vod = nil
    vinyl_response = JSON.parse(res.body)
    if vinyl_response["vods"] && vinyl_response["vods"].size > 0
      vinyl_response["vods"].each do |vod|
        if current_vod == nil && vod["recorded_on"].to_time.to_i <= Time.now.to_i
          # Check if the vod is longer than the diff between recorded on and timestamp
          vod_time = Time.now.to_i - vod["recorded_on"].to_time.to_i
          if vod_time.to_i < (vod["total_length"].to_i + 120) # Allow a 120 sec window to record the current stream
            current_vod = "#{vod["id"].to_s}?t=#{vod_time.to_s}s"
            break
          else
            return nil
          end
        end
      end
    end

    return current_vod
  end
end
