# Be sure to restart your server when you modify this file.

# Version of your assets, change this if you want to expire all your assets.
Rails.application.config.assets.version = '1.0'

# Load local config if it exists
Rails.application.config.before_configuration do
 env_file = File.join(Rails.root, 'config', 'local_env.yml')
 YAML.load(File.open(env_file)).each do |key, value|
   ENV[key.to_s] = value
  end if File.exists?(env_file)
end

# Add additional assets to the asset load path
# Rails.application.config.assets.paths << Emoji.images_path

# Precompile additional assets.
# application.js, application.css, and all non-JS/CSS in app/assets folder are already added.
Rails.application.config.assets.precompile += %w( clips_overview.js file_upload.js report.js report_small.js chatlogs.js emails.js suspensions.js suspension_guides.js darkmode.css )
