Rails.application.routes.draw do
  root 'sessions#index'

  get 'auth/:provider/callback', to: 'sessions#create'
  get 'auth/failure', to: 'sessions#failure'
  get 'signout', to: 'sessions#destroy', as: 'signout'

  get 'clips_overview', to: 'clips_overview#index'

  post 'emails/:id/reply', to: 'emails#reply', as: 'email_reply'
  get 'emails/:id/audits', to: 'emails#audit', as: 'email_audit'
  get 'emails/audits', to: 'emails#audits', as: 'email_audits'
  resources :emails, only: [:index, :show, :create, :update]

  get 'users/search', to: 'users#search', as: 'user_search'
  resources :users, only: [:index, :edit, :update]
  get 'users/:id/audits', to: 'users#audits', as: 'user_audits'

  get 'reports/me', to: 'reports#me'
  get 'reports/escalations', to: 'reports#escalations'
  get 'reports/pm_check', to: 'reports#pm_check'
  get 'reports/check_later', to: 'reports#check_later'
  get 'reports/search', to: 'reports#search', as: 'report_search'
  get 'reports/all', to: 'reports#all', as: 'all_reports'
  get 'reports/vod_timestamp', to: 'reports#vod_timestamp'
  get 'reports/channel_feed_comment_link', to: 'reports#channel_feed_comment_link'
  get 'reports/vod_comment_link', to: 'reports#vod_comment_link'
  match 'reports/partnerconduct_report', to: 'reports#partnerconduct_report', as: 'partnerconduct_report', via: [:get, :post]
  resources :reports, only: [:index, :show, :create, :update]

  resources :report_comments, only: [:create]

  resources :report_admins, only: [:index, :create, :update]

  get 'auto_resolves/active', to: 'auto_resolves#active'
  get 'auto_resolves/search', to: 'auto_resolves#search'
  resources :auto_resolves, only: [:show, :create, :update]

  resources :report_holds, only: [:show, :create, :update]

  get 'ban_exceptions/audits', to: 'ban_exceptions#audits'
  resources :ban_exceptions, only: [:index, :new, :create, :destroy]

  get 'suspensions/history/:target_user_id', to: 'suspensions#history', as: 'suspension_history'
  get 'suspensions/search', to: 'suspensions#search', as: 'suspension_search'
  match 'suspensions/checks', to: 'suspensions#checks', as: 'suspension_checks', via: [:get, :post]
  resources :suspensions, only: [:index, :show, :create]

  resources :suspension_comments, only: [:create]

  get 'chatlogs', to: 'chatlogs#index'
  get 'chatlogs/audits', to: 'chatlogs#audits'
  match 'chatlogs/chat_activity', to: 'chatlogs#chat_activity', as: 'chatlogs_chat_activity', via: [:get, :post]
  post 'chatlogs/delete', to: 'chatlogs#delete'

  get 'files/audits', to: 'file_uploads#audits'
  get 'files/search', to: 'file_uploads#search', as: 'file_uploads_search'
  resources :file_uploads, path: 'files', only: [:index, :new, :create, :destroy]

  get 'alt_lookup', to: 'alt_lookup#index', as: 'alt_lookup'
  get 'alt_lookup/audits', to: 'alt_lookup#audits', as: 'alt_lookup_audits'

  resources :suspension_guide_contents, only: [:index, :show, :new, :edit, :create, :update, :destroy], path: '/suspension_guide/contents'
  resources :suspension_guide_reasons, only: [:index, :show, :new, :edit, :create, :update, :destroy], path: '/suspension_guide/reasons'
  resources :suspension_guide_detailed_reasons, only: [:index, :show, :new, :edit, :create, :update, :destroy], path: '/suspension_guide/detailed_reasons'
  get 'suspension_guide/addon', to: 'suspension_guides#addon', as: 'suspension_guide_addon'
  get 'suspension_guide/audits', to: 'suspension_guides#audits', as: 'suspension_guide_audits'
  resources :suspension_guides, only: [:index, :show, :new, :edit, :create, :update, :destroy], path: '/suspension_guide'

  get 'url_resolver', to: 'url_resolver#index'

  match 'janitor/clear_chat_rules', to: 'janitor#clear_chat_rules', as: 'janitor_clear_chat_rules', via: [:get, :post]
  match 'janitor/clear_panels', to: 'janitor#clear_panels', as: 'janitor_clear_panels', via: [:get, :post]
  get 'janitor', to: 'janitor#index'
  get 'janitor/audits', to: 'janitor#audits', as: 'janitor_audits'
  get 'janitor/vod_strike', to: 'janitor#vod_strike', as: 'janitor_vod_strike'
  get 'janitor/id_to_login', to: 'janitor#id_to_login', as: 'janitor_id_to_login'
end
