# encoding: UTF-8
# This file is auto-generated from the current state of the database. Instead
# of editing this file, please use the migrations feature of Active Record to
# incrementally modify your database, and then regenerate this schema definition.
#
# Note that this schema.rb definition is the authoritative source for your
# database schema. If you need to create the application database on another
# system, you should be using db:schema:load, not running all the migrations
# from scratch. The latter is a flawed and unsustainable approach (the more migrations
# you'll amass, the slower it'll run and the greater likelihood for issues).
#
# It's strongly recommended that you check this file into your version control system.

ActiveRecord::Schema.define(version: 20160829121636) do

  create_table "alt_lookup_audits", force: :cascade do |t|
    t.string   "action"
    t.integer  "action_by"
    t.text     "command"
    t.datetime "created_at", null: false
    t.datetime "updated_at", null: false
  end

  add_index "alt_lookup_audits", ["action_by"], name: "index_alt_lookup_audits_on_action_by"

  create_table "auto_resolves", force: :cascade do |t|
    t.integer  "target_user_id"
    t.integer  "from_user_id"
    t.string   "content"
    t.string   "content_id"
    t.datetime "disabled_at"
    t.integer  "created_by"
    t.datetime "resolve_until"
    t.datetime "created_at",     null: false
    t.datetime "updated_at",     null: false
  end

  add_index "auto_resolves", ["content_id"], name: "index_auto_resolves_on_content_id"
  add_index "auto_resolves", ["resolve_until"], name: "index_auto_resolves_on_resolve_until"

  create_table "ban_exception_audits", force: :cascade do |t|
    t.string   "action"
    t.integer  "action_by"
    t.text     "content"
    t.text     "remote_ip"
    t.datetime "created_at", null: false
    t.datetime "updated_at", null: false
  end

  create_table "ban_exceptions", force: :cascade do |t|
    t.integer  "target_user_id"
    t.string   "reason"
    t.integer  "created_by"
    t.datetime "created_at",     null: false
    t.datetime "updated_at",     null: false
  end

  add_index "ban_exceptions", ["target_user_id"], name: "index_ban_exceptions_on_target_user_id", unique: true

  create_table "chatlogs_audits", force: :cascade do |t|
    t.string   "action"
    t.integer  "action_by"
    t.text     "command"
    t.datetime "created_at", null: false
    t.datetime "updated_at", null: false
  end

  create_table "email_audits", force: :cascade do |t|
    t.integer  "email_id"
    t.string   "action"
    t.integer  "action_by"
    t.text     "content",    limit: 16777215
    t.datetime "created_at",                  null: false
    t.datetime "updated_at",                  null: false
  end

  add_index "email_audits", ["action_by"], name: "index_email_audits_on_action_by"
  add_index "email_audits", ["email_id"], name: "index_email_audits_on_email_id"

  create_table "emails", force: :cascade do |t|
    t.string   "s3_message_id"
    t.string   "direction"
    t.string   "status"
    t.integer  "assigned_to"
    t.string   "subject"
    t.text     "from"
    t.text     "to"
    t.text     "cc"
    t.string   "email_message_id"
    t.string   "in_reply_to"
    t.datetime "created_at",       null: false
    t.datetime "updated_at",       null: false
  end

  add_index "emails", ["assigned_to"], name: "index_emails_on_assigned_to"
  add_index "emails", ["email_message_id"], name: "index_emails_on_email_message_id"
  add_index "emails", ["status"], name: "index_emails_on_status"

  create_table "file_upload_audits", force: :cascade do |t|
    t.string   "action"
    t.integer  "action_by"
    t.text     "content"
    t.text     "remote_ip"
    t.datetime "created_at", null: false
    t.datetime "updated_at", null: false
  end

  create_table "file_uploads", force: :cascade do |t|
    t.integer  "user_id"
    t.text     "url"
    t.string   "file"
    t.string   "channel"
    t.datetime "created_at", null: false
    t.datetime "updated_at", null: false
  end

  add_index "file_uploads", ["channel"], name: "index_file_uploads_on_channel"

  create_table "janitor_audits", force: :cascade do |t|
    t.string   "action"
    t.integer  "action_by"
    t.text     "content"
    t.text     "remote_ip"
    t.datetime "created_at", null: false
    t.datetime "updated_at", null: false
  end

  create_table "permissions", force: :cascade do |t|
    t.integer  "user_id"
    t.boolean  "edit_user",                 default: false
    t.boolean  "view_reports",              default: false
    t.boolean  "view_chatlogs",             default: false
    t.boolean  "delete_chatlogs",           default: false
    t.boolean  "delete_file_uploads",       default: false
    t.boolean  "view_file_uploads_audits",  default: false
    t.boolean  "manage_ban_exceptions",     default: false
    t.datetime "created_at",                                null: false
    t.datetime "updated_at",                                null: false
    t.boolean  "view_alt_lookup_audits",    default: false
    t.boolean  "manage_suspension_guide",   default: false
    t.boolean  "view_emails",               default: false
    t.boolean  "view_email_audits",         default: false
    t.boolean  "view_report_admin_history", default: false
    t.boolean  "use_alt_lookup",            default: false
    t.boolean  "use_janitor",               default: false
    t.boolean  "view_janitor_audits",       default: false
    t.boolean  "counter_check_suspensions", default: false
    t.boolean  "view_all_chatlogs",         default: false
  end

  add_index "permissions", ["user_id"], name: "index_permissions_on_user_id"
  add_index "permissions", ["user_id"], name: "unique_user_id", unique: true

  create_table "report_admins", force: :cascade do |t|
    t.integer  "admin_id"
    t.integer  "admin_weight"
    t.datetime "disabled_at"
    t.integer  "disabled_by"
    t.datetime "created_at",   null: false
    t.datetime "updated_at",   null: false
  end

  add_index "report_admins", ["disabled_at"], name: "index_report_admins_on_disabled_at"

  create_table "report_audits", force: :cascade do |t|
    t.integer  "report_id"
    t.string   "action"
    t.integer  "action_by"
    t.integer  "auto_resolve_id"
    t.text     "diff",            limit: 16777215
    t.integer  "hold_id"
    t.datetime "created_at",                       null: false
    t.datetime "updated_at",                       null: false
  end

  add_index "report_audits", ["report_id"], name: "index_report_audits_on_report_id"

  create_table "report_comments", force: :cascade do |t|
    t.integer  "report_id"
    t.integer  "created_by"
    t.text     "comment"
    t.datetime "created_at",  null: false
    t.datetime "updated_at",  null: false
  end

  add_index "report_comments", ["report_id"], name: "index_report_comments_on_report_id"

  create_table "report_holds", force: :cascade do |t|
    t.integer  "report_id"
    t.integer  "created_by"
    t.datetime "hold_until"
    t.datetime "disabled_at"
    t.datetime "created_at",  null: false
    t.datetime "updated_at",  null: false
  end

  add_index "report_holds", ["report_id"], name: "index_report_holds_on_report_id"

  create_table "reports", force: :cascade do |t|
    t.string   "status"
    t.integer  "assigned_to"
    t.string   "from_user_username"
    t.integer  "from_user_id"
    t.string   "from_user_type"
    t.boolean  "from_user_partner"
    t.string   "target_user_username"
    t.integer  "target_user_id"
    t.string   "target_user_type"
    t.boolean  "target_user_partner"
    t.string   "content"
    t.string   "content_id"
    t.string   "reason"
    t.text     "description",              limit: 16777215
    t.datetime "created_at",                                null: false
    t.datetime "updated_at",                                null: false
    t.string   "from_user_display_name"
    t.string   "target_user_display_name"
    t.string   "origin"
    t.string   "extra1"
  end

  add_index "reports", ["assigned_to"], name: "index_reports_on_assigned_to"
  add_index "reports", ["content"], name: "index_reports_on_content"
  add_index "reports", ["from_user_id"], name: "index_reports_on_from_user_id"
  add_index "reports", ["reason"], name: "index_reports_on_reason"
  add_index "reports", ["status"], name: "index_reports_on_status"
  add_index "reports", ["target_user_id"], name: "index_reports_on_target_user_id"
  add_index "reports", ["target_user_username"], name: "index_reports_on_target_user_username"
  add_index "reports", ["from_user_username"], name: "index_reports_on_from_user_username"

  create_table "suspension_checks", force: :cascade do |t|
    t.integer  "suspension_id"
    t.string   "suspension_from_user_id"
    t.string   "status"
    t.integer  "checked_by"
    t.datetime "created_at",                  null: false
    t.datetime "updated_at",                  null: false
  end

  add_index "suspension_checks", ["suspension_id"], name: "index_suspension_checks_on_suspension_id"
  add_index "suspension_checks", ["suspension_from_user_id"], name: "index_suspension_checks_on_suspension_from_user_id"
  add_index "suspension_checks", ["status"], name: "index_suspension_checks_on_status"
  add_index "suspension_checks", ["created_at"], name: "index_suspension_checks_on_created_at"

  create_table "suspension_comments", force: :cascade do |t|
    t.integer  "suspension_id"
    t.integer  "created_by"
    t.text     "comment"
    t.datetime "created_at",  null: false
    t.datetime "updated_at",  null: false
  end

  add_index "suspension_comments", ["suspension_id"], name: "index_suspension_comments_on_suspension_id"

  create_table "suspension_guide_audits", force: :cascade do |t|
    t.string   "action"
    t.integer  "action_by"
    t.text     "diff",       limit: 16777215
    t.datetime "created_at",                  null: false
    t.datetime "updated_at",                  null: false
  end

  create_table "suspension_guide_contents", force: :cascade do |t|
    t.string   "content"
    t.text     "content_description"
    t.datetime "created_at",          null: false
    t.datetime "updated_at",          null: false
  end

  add_index "suspension_guide_contents", ["content"], name: "index_suspension_guide_contents_on_content", unique: true

  create_table "suspension_guide_detailed_reasons", force: :cascade do |t|
    t.string   "detailed_reason"
    t.datetime "created_at",      null: false
    t.datetime "updated_at",      null: false
  end

  add_index "suspension_guide_detailed_reasons", ["detailed_reason"], name: "index_suspension_guide_detailed_reasons_on_detailed_reason", unique: true

  create_table "suspension_guide_reasons", force: :cascade do |t|
    t.string   "reason"
    t.text     "reason_description"
    t.datetime "created_at",         null: false
    t.datetime "updated_at",         null: false
  end

  add_index "suspension_guide_reasons", ["reason"], name: "index_suspension_guide_reasons_on_reason", unique: true

  create_table "suspension_guides", force: :cascade do |t|
    t.boolean  "ignore",                                       default: false
    t.integer  "sorting",                     limit: 8
    t.integer  "content_id"
    t.integer  "reason_id"
    t.integer  "detailed_reason_id"
    t.string   "detailed_reason_title"
    t.text     "detailed_reason_description", limit: 16777215
    t.text     "strike_details",              limit: 16777215
    t.boolean  "ip_ban",                                       default: false
    t.boolean  "permanent",                                    default: false
    t.boolean  "clear_images",                                 default: false
    t.text     "strike_form_note"
    t.boolean  "remove_offending_content",                     default: false
    t.datetime "created_at",                                                   null: false
    t.datetime "updated_at",                                                   null: false
    t.boolean  "escalate",                                     default: false
    t.text     "offense_send_to_user"
    t.text     "violated_tos_section"
    t.boolean  "list_in_quick_select",                         default: false
  end

  add_index "suspension_guides", ["list_in_quick_select"], name: "index_suspension_guides_on_list_in_quick_select"

  create_table "suspensions", force: :cascade do |t|
    t.string   "from_user_id"
    t.string   "target_user_username"
    t.integer  "target_user_id"
    t.string   "target_user_type"
    t.boolean  "target_user_partner"
    t.string   "content"
    t.string   "reason"
    t.string   "detailed_reason"
    t.text     "description",              limit: 16777215
    t.integer  "duration"
    t.datetime "created_at",                                null: false
    t.datetime "updated_at",                                null: false
    t.string   "from_user_type"
    t.integer  "ip_ban"
    t.boolean  "cleared_channel_images"
    t.string   "target_user_display_name"
    t.string   "origin"
    t.string   "target_user_game"
    t.integer  "current_live_vod",         limit: 8
  end

  add_index "suspensions", ["content"], name: "index_suspensions_on_content"
  add_index "suspensions", ["detailed_reason"], name: "index_suspensions_on_detailed_reason"
  add_index "suspensions", ["reason"], name: "index_suspensions_on_reason"
  add_index "suspensions", ["target_user_id"], name: "index_suspensions_on_target_user_id"
  add_index "suspensions", ["target_user_username"], name: "index_suspensions_on_target_user_username"

  create_table "user_audits", force: :cascade do |t|
    t.integer  "user_id"
    t.string   "action"
    t.integer  "action_by"
    t.text     "diff",       limit: 16777215
    t.text     "remote_ip"
    t.datetime "created_at",                  null: false
    t.datetime "updated_at",                  null: false
  end

  add_index "user_audits", ["user_id"], name: "index_user_audits_on_user_id"

  create_table "users", force: :cascade do |t|
    t.string   "email"
    t.boolean  "enabled",                   default: false
    t.integer  "twitch_id"
    t.string   "report_mode",               default: "fade"
    t.string   "style",                     default: "white"
    t.boolean  "report_sound_notification", default: true
    t.datetime "created_at",                                  null: false
    t.datetime "updated_at",                                  null: false
  end

  add_index "users", ["email"], name: "index_users_on_email", unique: true

end
