﻿// ==UserScript==
// @name        Autofill send copy to self
// @namespace   commanderroot
// @copyright   CommanderRoot
// @author      CommanderRoot
// @description Automatically sets the "Send me a copy of my responses." checkbox
// @include     https://docs.google.com/a/mods.twitch.tv/forms/d/1okK_BivOLQT9PYXgHj4SeRrABc6sSqPm-H4XUccAWG8/viewform*
// @include     https://docs.google.com/a/mods.twitch.tv/forms/d/e/1FAIpQLScvosX--BknDBSjvCimL3Hh8wHxphMS5xjfwgcnCX3rIH4t1A/viewform*
// @version     2.2
// @downloadURL https://leviathan.moderation.twitch.tv/js/autofill_send_copy_to_self.user.js
// @updateURL   https://leviathan.moderation.twitch.tv/js/autofill_send_copy_to_self.meta.js
// @grant       none
// @run-at      document-end
// ==/UserScript==
"use strict";

// Check the box (old)
// document.getElementById("emailReceipt").checked = true;

// For new design
function add_jquery() {
  var script = document.createElement("script");
  script.type = "text/javascript";
  script.src = "https://ajax.googleapis.com/ajax/libs/jquery/2.2.2/jquery.min.js";
  var head = document.getElementsByTagName('head')[0];
  if (head)
    head.appendChild(script);
}
add_jquery();

function check_jquery_status()
{
  if (window.jQuery) {
    // jQuery is loaded
    console.log("jQuery is loaded");
    set_send_to_self();
  } else {
    // jQuery is not loaded
    console.log("jQuery is NOT loaded");
    setTimeout(function () { check_jquery_status(); }, 100);
  }
}
check_jquery_status();


function set_send_to_self()
{
  // Set the input var
  jQuery('input[name="emailReceipt"]').val("true");
  // Make it look good
  jQuery('div[aria-label="Send me a copy of my responses."]').addClass("isChecked");
  console.log("Set the send copy to me option");
}
