// ==UserScript==
// @name        Better AA
// @namespace   commandertos
// @version     0.3.133
// @description Better AA with Suspension Appeals options
// @author      CommanderRoot
// @copyright   CommanderRoot
// @match       https://admin.internal.twitch.tv/admin
// @match       https://admin.internal.twitch.tv/admin/users/*
// @match       https://admin.internal.twitch.tv/admin/users?*
// @grant       GM_addStyle
// @grant       GM_getValue
// @grant       GM_setValue
// @downloadURL https://leviathan.moderation.twitch.tv/js/better_aa.user.js
// ==/UserScript==
'use strict';

var script_enabled = GM_getValue('enabled');

function add_enabled_disable_option() {
  $('#utility_nav').prepend('<li><label for="better_aa_enabled" style="display: inline">Better AA?</label><input id="better_aa_enabled" type="checkbox" value="true" /></li>');
  if (script_enabled != undefined) {
    $('#better_aa_enabled').prop('checked', script_enabled);
  }

  $('#better_aa_enabled').click(function () {
    if ($(this).is(':checked')) {
      GM_setValue('enabled', true);
    } else {
      GM_setValue('enabled', false);
    }
    // Refresh the page so the setting has an effect
    window.location.reload();
  });
}

function add_search_input_cleaner_function() {
  $('form[action="/admin/users"]').submit(function (event) {
    var new_value = $('form[action="/admin/users"] input[name="query"]').val();
    new_value = new_value.replace('<', '');
    new_value = new_value.replace('>', '');
    new_value = new_value.trim();
    $('form[action="/admin/users"] input[name="query"]').val(new_value);
  });
}

function hide_quick_buttons() {
  GM_addStyle('.action_items{display:none !important;}');
}

function hide_not_needed_right_options() {
  GM_addStyle('\
    #youtube-connections_sidebar_section{display:none !important;}\
    #partner_sidebar_section{display:none !important;}\
    #rename_sidebar_section{display:none !important;}\
    #two_factor-authentication_sidebar_section{display:none !important;}\
    #delete-cookies_sidebar_section{display:none !important;}\
    #delete-facebook-connection_sidebar_section{display:none !important;}\
    #clear-chat-bans_sidebar_section{display:none !important;}\
    ');

  // Remove Ban form and button
  $('form[action$="/ban"]').remove();
}

function remove_confirm_from_form() {
  // Remove confirm question from the two buttons
  $('input[data-confirm]').each(function (i, obj) {
    if ($(obj).data("confirm") == "Are you sure you wish to change this user's password? Doing so will kill the current stream, reset the user's stream keys and log out the user.") {
      // Remove old
      $(obj).remove();
      // Add new
      $('form[action$="/change_password"]').append('<div><input type="submit" value="Change Password"></div>');
    } else if ($(obj).data("confirm") == "Are you sure you wish to delete this user's site oauth token?") {
      // Remove old
      $(obj).remove();
      // Add new
      $('form[action$="/delete_site_oauth_token"]').append('<div><input name="commit" type="submit" value="Delete User\'s Site OAuth Token"></div>');
    }
  });
}

function add_compromised_reset_form() {
  var script = document.createElement('script');
  script.type = 'text/javascript';
  script.text = "var done_counter = 0;\
    function gen_random_pw() {\
          var n = 16;\
      var text = '';\
          var possible = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';\
          for(var i=0; i < n; i++){\
            text += possible.charAt(Math.floor(Math.random() * possible.length));\
          }\
      return text;\
        }\
\
    function reset_compromised_account() {\
      $('#reset_compromised_account_button').prop('disabled', true);\
      var target_user = window.location.pathname.split('/')[3];\
\
      /* Reset stream key */ \
      $.ajax({ \
        url: '/admin/users/' + target_user + '/reset_stream_key',\
        type: 'POST',\
        data: { _method: 'post', authenticity_token: $('input[name=authenticity_token]').val() },\
        success:function(d, textStatus, jqXHR){\
          $('#reset_stream_key_status').text('Stream key resetted');\
\
          /* Reset pw */\
          $.ajax({ \
            url: '/admin/users/' + target_user + '/change_password',\
            type: 'POST',\
            data: { utf8: '✓', authenticity_token: $('input[name=authenticity_token]').val(), new_password: gen_random_pw(), commit: 'Change Password' },\
            success:function(d, textStatus, jqXHR){\
              $('#change_pw_status').html('Reset PW done');\
\
              /* Remove oauth */\
              $.ajax({\
                url: '/admin/users/' + target_user + '/delete_site_oauth_token',\
                type: 'POST',\
                data: { utf8: '✓', authenticity_token: $('input[name=authenticity_token]').val(), commit: \"Delete User's Site OAuth Token\" },\
                success:function(d, textStatus, jqXHR){\
                  $('#oauth_delete_status').html('Site Oauth deleted');\
\
                  /* Remove Oauth apps */\
                  $.ajax({\
                    url: '/admin/users/' + target_user + '/revoke_all_oauth_authorizations',\
                    type: 'POST',\
                    data: { utf8: '✓', authenticity_token: $('input[name=authenticity_token]').val(), commit: \"Revoke User's OAuth Tokens\" },\
                    success:function(d, textStatus, jqXHR){\
                      $('#oauth_apps_delete_status').html('All OAuth Authorizations revoked');\
\
                      /* Change email */\
                      var current_email = $(\"th:contains('Email')\").filter(function(){ return (/^Email$/).test($(this).text())}).parent().children('td').text();\
                      if(current_email == '' || !current_email) {\
                        current_email = 'no_current_email@twitch';\
                      }\
\
                      $.ajax({\
                        url: '/admin/users/' + target_user,\
                        type: 'POST',\
                        data: {\
                          utf8: '✓',\
                          _method: 'put',\
                          authenticity_token: $('input[name=authenticity_token]').val(),\
                          commit: 'Save',\
                          'user[email]': current_email + '.twitch'\
                        },\
                        success:function(d, textStatus, jqXHR){\
                          $('#email_change_status').html('Email changed');\
\
                          /* Unban user */\
                          $.ajax({\
                            url:'/admin/users/' + target_user + '/unban',\
                            type: 'POST',\
                            data: { utf8: '✓', authenticity_token: $('input[name=authenticity_token]').val(), commit: 'Unban User' },\
                            success:function(d, textStatus, jqXHR){\
                              $('#unban_status').html('User unbanned');\
                              window.location.reload();\
                            }\
                          });\
                        }\
                      });\
                    }\
                  });\
                }\
              });\
            }\
          });\
        }\
      });\
    }";
  var head = document.getElementsByTagName('head')[0];
  if (head)
    head.appendChild(script);

  // Add new Change PW and unban button
  $('<div class="sidebar_section panel" id="reset_compromised_account_section">\
      <h3>Reset compromised account</h3>\
      <div class="panel_contents">\
      <div><button id="reset_compromised_account_button" onclick="reset_compromised_account();">Reset compromised account</button></div>\
      <div></div>\
      <div id="reset_stream_key_status"></div>\
      <div id="change_pw_status"></div>\
      <div id="oauth_delete_status"></div>\
      <div id="oauth_apps_delete_status"></div>\
      <div id="email_change_status"></div>\
      <div id="unban_status"></div>\
      <div></div>\
      </div>\
      </div>').insertAfter("#search_sidebar_section");

}

// Always add the option to enable / disable on the page
add_enabled_disable_option();

if (script_enabled != undefined && script_enabled == true) {
  console.log('Better AA is enabled.');

  if (window.location.pathname == '/admin/users' || window.location.pathname == '/admin') {
    // On the search / multiple user overview or the "front page"
    console.log('Better AA: On front page or user search / overview');
    add_search_input_cleaner_function();
  } else if (window.location.pathname.substr(0, 13) == '/admin/users/' && window.location.pathname.length > 13) {
    // On a "profile" page
    console.log('Better AA: On a profile');
    add_search_input_cleaner_function();
    hide_quick_buttons();
    hide_not_needed_right_options();
    remove_confirm_from_form();
    add_compromised_reset_form();
  }
} else {
  console.log('Better AA is disabled.');
}
