package main

import (
	"bufio"
	"fmt"
	"os"
	"strconv"
	"strings"

	"code.justin.tv/security-cop/fruit/fruitinmemory"
)

func main() {
	fruitClient := fruitinmemory.New()

	s := bufio.NewScanner(os.Stdin)
	for s.Scan() {
		args := strings.Split(s.Text(), " ")
		if len(args) == 1 {
			fruitName := args[0]

			fr, err := fruitClient.Get(fruitName)
			if err != nil {
				fmt.Println(err)
				continue
			}

			fmt.Printf("%s %d\n", fr.ID, fr.Price)
		} else if len(args) == 2 {
			fruitName := args[0]
			fruitPrice, err := strconv.Atoi(args[1])
			if err != nil {
				fmt.Println(err)
				continue
			}

			if err := fruitClient.UpdatePrice(fruitName, fruitPrice); err != nil {
				fmt.Println(err)
				continue
			}

			fmt.Printf("%s %d\n", fruitName, fruitPrice)
		} else {
			fmt.Printf("invalid args: %v\n", args)
		}
	}
}
