package resolver

import (
	"github.com/graph-gophers/graphql-go"
)

// CommentFields ...
type CommentFields struct {
	ID      graphql.ID
	Content string
	Author  graphql.ID
}

type comment struct {
	fields CommentFields
	users  usersAPI
}

func (c comment) ID() graphql.ID {
	return c.fields.ID
}

func (c comment) Content() string {
	return c.fields.Content
}

func (c comment) Author() *user {
	if author, ok := c.users.Get(c.fields.Author); ok {
		return author
	}
	return nil
}
