package resolver

import (
	"testing"

	"github.com/graph-gophers/graphql-go"
	"github.com/stretchr/testify/assert"
)

func TestComment(t *testing.T) {
	const id = "id"
	const content = "content"
	const authorID = "authorid"

	users := new(mockUsersAPI)
	c := &comment{
		fields: CommentFields{
			ID:      graphql.ID(id),
			Author:  graphql.ID(authorID),
			Content: content,
		},
		users: users,
	}

	assert.Equal(t, graphql.ID(id), c.ID())
	assert.Equal(t, content, c.Content())

	t.Run("Author", func(t *testing.T) {
		t.Run("present", func(t *testing.T) {
			u := &user{fields: UserFields{ID: authorID}}
			users.On("Get", graphql.ID(authorID)).Return(u, true).Once()
			defer users.AssertExpectations(t)

			assert.Equal(t, u, c.Author())
		})

		t.Run("missing", func(t *testing.T) {
			users.On("Get", graphql.ID(authorID)).Return(nil, false).Once()
			defer users.AssertExpectations(t)

			assert.Nil(t, c.Author())
		})
	})
}
