package resolver

import (
	"testing"

	"github.com/graph-gophers/graphql-go"
	"github.com/stretchr/testify/assert"
)

func TestPost(t *testing.T) {
	const id = "id"
	const content = "content"
	const authorID = "authorid"
	const commentID = "commentid"

	comments := new(mockCommentsAPI)
	users := new(mockUsersAPI)
	p := &post{
		fields: PostFields{
			ID:       graphql.ID(id),
			Author:   graphql.ID(authorID),
			Content:  content,
			Comments: []graphql.ID{commentID},
		},
		comments: comments,
		users:    users,
	}

	assert.Equal(t, graphql.ID(id), p.ID())
	assert.Equal(t, content, p.Content())

	t.Run("Author", func(t *testing.T) {
		t.Run("present", func(t *testing.T) {
			u := &user{fields: UserFields{ID: authorID}}
			users.On("Get", graphql.ID(authorID)).Return(u, true).Once()
			defer users.AssertExpectations(t)

			assert.Equal(t, u, p.Author())
		})

		t.Run("missing", func(t *testing.T) {
			users.On("Get", graphql.ID(authorID)).Return(nil, false).Once()
			defer users.AssertExpectations(t)

			assert.Nil(t, p.Author())
		})
	})

	t.Run("Comments", func(t *testing.T) {
		c := &comment{fields: CommentFields{ID: commentID}}
		comments.On("Get", graphql.ID(commentID)).Return(c, true).Once()
		defer comments.AssertExpectations(t)

		assert.Equal(t, []*comment{c}, p.Comments(struct {
			First int32
		}{First: 10}))
	})
}
