package main

import (
	"flag"
	"io/ioutil"
	"log"
	"net/http"
	"os"

	"github.com/graph-gophers/graphql-go"
	"github.com/graph-gophers/graphql-go/relay"
)

type query struct{}

func (q *query) MyGroups() []*group {
	return []*group{
		{id: "admin", name: "admin"},
		{id: "infra", name: "infra"},
	}
}

type group struct {
	id   string
	name string
}

func (g *group) ID() graphql.ID {
	return graphql.ID(g.id)
}

func (g *group) Name() string {
	return g.name
}

func main() {
	flag.Parse()

	f, err := os.Open("schema.graphql")
	if err != nil {
		panic(err)
	}

	s, err := ioutil.ReadAll(f)
	if err != nil {
		panic(err)
	}

	schema := graphql.MustParseSchema(string(s), &query{})

	http.Handle("/graphql", &relay.Handler{Schema: schema})
	http.Handle("/", &graphiQL{})
	log.Print("listening on 127.0.0.1:8081")
	log.Fatal(http.ListenAndServe("127.0.0.1:8081", nil))
}
