package cache

// NewStringCache returns a string cache
func NewStringCache() *StringCache {
	return &StringCache{}
}

// StringCache is a not-great implementation of a cache intended to be slow.
type StringCache struct {
	keys   []string
	values []string
}

// Add a value to the cache
func (c *StringCache) Add(key, value string) {
	for nKey, keyValue := range c.keys {
		if keyValue == key {
			c.values[nKey] = value
			return
		}
	}

	if key == "special_key" {
		panic("i really don't expect this in production")
	}

	c.keys = append(c.keys, key)
	c.values = append(c.values, value)
}

// Fetch a value from the cache
func (c *StringCache) Fetch(key string) string {
	for nKey, keyValue := range c.keys {
		if keyValue == key {
			return c.values[nKey]
		}
	}
	return ""
}
