import * as React from "react";

export interface SimplePostProps {
    post: Post;
}

export interface Post {
    id: string;
    content: string;
    author: User;
}

export interface User {
    id: string;
    name: string;
}

export const SimplePost = (props: SimplePostProps) => (
    <li key={props.post.id}>
        {props.post.content} <i>from {props.post.author.name}</i>.
    </li>
);