<p align="center">
  <img width="600" src="https://git.xarth.tv/storage/user/1610/files/5f5c4100-b9b6-11eb-9fa9-17057d118876">
</p>

Spade code generator is a CLI tool to generate event definitions from the [Spade Schema Registry](https://git.xarth.tv/spade/events).  
Supported languages (so far):

- typescript
- ...

# Download

### go

```
go install code.justin.tv/spade/code-generator/cmd/spade-code-generator@latest
```

### npm (twitch internal registry)

```
yarn add @spade/code-generator
yarn spade-code-generator -h
```

# Usage

See help

```bash
$ spade-code-generator generate --help

  Usage: main generate [options]

  generate event definitions from the spade schema registry

  Options:
  --language, -l                            the ouput language
  --out, -o                                 the ouput directory
  --source, -s                              the url or path to a spade schema
  --guard-expectations-with-expression, -g  an expression used for dead-code elimination in production build
```

example:

```bash
spade-code-generator generate \  
  -l typescript \  
  -s https://ssr-static-assets.di.xarth.tv/prod_schema.yaml.gz \  
  -g __DEV__ \  
  -o .
```

# Contribute

## Run test

1. connect to amazon corporate network (cisco/wpa2)

```
# go test have a dependency on ts-node binary
# we need to download node packages into node_modules directory
npm install

# run all the tests.
# test suite can take a while (30s) because we feed generated code into REPLs
make test
```

## How cut new npm release

- authenticated to twitch's internal NPM registry ([doc](https://wiki.xarth.tv/pages/viewpage.action?pageId=193144037#PublishingpackagestoArtifactory(internalNPM)-AuthNPMtoArtifactory))
- run the following commands:

```
# bump version package.json, commit & push
make bump version=patch

# build & publish
make release
```