# value_lengths_to_be_between
This expectation requires the contents of a string field to have a length within a specific
range, inclusive.  If you require your string to have a singular length, then you should specify
define `min` and `max` with the same value.  Specifying zero for `min` is allowed in the cases
where a string can be `null`.

This is a default expectation for any `string` field.

## Supported Types
* [string](../types/string.md)

## Incompatible Expectations
The following expectations are not allowed to be specified in addition to this expectation.
* [values_to_be_in_set](values_to_be_in_set.md)
* [values_to_match_regex_list](values_to_match_regex_list.md)

## Arguments
* `max` - The maximum length (inclusive) for a string.  Must be >= 1 and >= `min`.
* `min` - The minimum length (inclusive) for a string.  Must be >= 0 and <= `max`.

## Examples
* TBD
