# values_to_match_regex_list
This expectation requires the contents of a string field to match one of the supplied patterns
(regular expressions).  The configured patterns must be compatible with python's
[__re__ module](https://docs.python.org/3/library/re.html) and
[golang's __regexp__ module](https://golang.org/pkg/regexp/).  For performance reasons, the number
of patterns allowed in the list is soft capped at 3.  If you require the contents of your field
to exactly match the supplied pattern, then you will need to use `^` and `$`.

## Supported Types
* [string](../types/string.md)

## Incompatible Expectations
The following expectations are not allowed to be specified in addition to this expectation.
* [value_lengths_to_be_between](value_lengths_to_be_between.md)

## Arguments
* `patterns` - A list of regular expressions.  Soft capped at 3 elements.

## Examples
* [ip](../fields/ip.md)
