#!/bin/bash
# Don't use set -euo pipefail since we are sourcing this script and will potentially
# exit the user's session.

if [ ! -d venv ]; then
    echo "Creating venv virtual environment"
    python3 -m venv venv
fi

source venv/bin/activate

if [[ -z "$VIRTUAL_ENV" ]]; then
    echo "ERROR: There was a problem activating your virtual environment."
    echo "Please consult the docs or ask for help in #spade-schema-registry."
else
    pip install -r scripts/requirements.txt
fi

git config core.hooksPath scripts/hooks/
