# Events
This directory (and possibly subdirectories) contain Spade events.  Each event is defined by a
YAML object keyed by the name of the event and stored in a file with the event name prior to the
`.yaml` suffix.  The file naming convention here is a soft requirement.

Please use the [event template](../templates/event.yaml) when making a new event.

## Arguments
All events must have a `description`. The description must be 100 characters or longer. It is good practice to make liberal use of comments in this file to describe what this event is for.

Events are primarily composed of [`fields`](../fields/README.md) and
[`groups`](../fields/README.md). You can utilize more than one group, and intersecting fields are
only represented once.  These lists are required to be sorted.  All events implicitly have the
[`all_events_common_fields`](../groups/all_events_common_fields.md) group.

Finally, most Spade events follow the pattern of "similar, but different" so you can specify
`overrides` to override the definition of fields utilized in the event.  Ideally, you should
unify the definition for the `field` instead.  This mechanism should be
used sparingly and after much consideration, because each use increases the cognitive complexity of
your event.

## Example
filename: `invariant_ping.yaml`
```yaml
invariant_ping:
  description: An event fired 2 times every second by Data Platform to canary Spade.
  # There is no tracking spec, and this event was first created in July 2016.
  # Data Platform uses this event to canary Spade and to track data loss and duplication.
  # https://scout.di.xarth.tv/pivot/d/ace8/-Raw-_Invariant_Ping
  fields:
    - sequence_number
    - origin
  groups:
    - internal_ip
  overrides:
    - name: sequence_number
      expectations: []
```
