# values_to_be_in_set
This expectation requires the contents of a field to match an element in the supplied set. The
[enum](../types/enum.md) type uses this expectation as part of its definition, so specifying this
expectation a second time on a field of that type is not allowed.  Due to technical limitations the
number of possible elements allowed in the set is soft capped at 100.  While not directly specified
in the set of values, `null` is allowed for this expectation.  If you require values to be non-null,
then you will need to additionally specify [values_to_not_be_null](values_to_not_be_null.md).

## Supported Types
* [long](../types/long.md)
* [bool](../types/bool.md)
* [float](../types/float.md)
* [string](../types/string.md)
* [timestamp](../types/timestamp.md)

## Incompatible Expectations
The following expectations are not allowed to be specified in addition to this expectation.
* [value_lengths_to_be_between](value_lengths_to_be_between.md)

## Arguments
* `values` - A list of values.  Soft capped at 100 elements.

## Examples
* [origin](../fields/origin.md)
