#!/usr/bin/env python3
"""
This script updates CODEOWNERS with local, untracked field/group/event files.
"""

import argparse
import subprocess

import build


def find_objects(path):
    cmd = ['git', 'ls-files', '--others', '--exclude-standard', path]
    output = subprocess.check_output(cmd).decode()
    for line in output.split('\n'):
        line = line.strip()
        if not line.endswith('.yaml'):
            continue
        # yield the object name: i.e. 'example' from '../events/example.yaml'
        yield line.split('/')[-1].split('.')[0]


def main():
    parser = argparse.ArgumentParser(description='Load your local changes into CODEOWNERS.')
    parser.add_argument('owner', metavar='OWNER', type=str, help='the owner group for the event')
    args = parser.parse_args()

    # Find all new files
    events = list(find_objects('../events/'))
    fields = list(find_objects('../fields/'))
    groups = list(find_objects('../groups/'))

    build.update_codeowners(args.owner, events, fields, groups)


if __name__ == '__main__':
    main()
