#!/bin/bash --
set -euo pipefail

git checkout mainline
git pull --rebase
git checkout integration-schema-registry
git pull --rebase
git checkout mainline -- $(git ls-tree --name-only -r mainline | egrep 'scripts/*')
# This gets the changes to scripts directory from the mainline branch and 
# gets them into the integration-schema-registry branch
git add -A
git commit -m "sync scripts from mainline" --no-verify 
# integration events don't currently pass some tests due to having hyphens in the name,
# and no sensitivities etc. This is irrelevant for integration currently, so skipping 
# those checks. This can be changed in the future if there are disagreements, but will
# require changes in the integration tests
git push