
<!DOCTYPE html>
<html>
<head>
    <title>OCR PDF Renamer</title>
    <style>
        body { font-family: Arial; padding: 20px; background: #111; color: #eee; }
        button { padding: 10px 20px; margin: 10px; }
        #log { background: #222; padding: 10px; height: 300px; overflow-y: scroll; white-space: pre-wrap; }
    </style>
</head>
<body>
<h1>OCR PDF Renamer GUI</h1>

<form id="settings">
    <label>Target Directory:</label><br>
    <input type="text" id="targetDir" value="/path/to/pdfs" size="60"><br><br>
    <input type="checkbox" id="autoResume"> Auto Resume every 10 seconds<br>
    <button type="button" onclick="start()">Start</button>
    <button type="button" onclick="pause()">Pause</button>
    <button type="button" onclick="resume()">Resume</button>
    <button type="button" onclick="exportLog()">Export Log</button>
</form>

<h3>Live Log</h3>
<div id="log">Ready.</div>

<script>
let interval;

function start() {
    fetch('worker.php?action=start&dir=' + encodeURIComponent(document.getElementById('targetDir').value));
    if (document.getElementById('autoResume').checked) {
        interval = setInterval(resume, 10000);
    }
}

function pause() {
    fetch('worker.php?action=pause');
    clearInterval(interval);
}

function resume() {
    fetch('worker.php?action=resume');
    updateLog();
}

function exportLog() {
    window.location.href = 'worker.php?action=export';
}

function updateLog() {
    fetch('logs/log.txt').then(res => res.text()).then(txt => {
        document.getElementById('log').innerText = txt;
    });
}

setInterval(updateLog, 5000);
</script>
</body>
</html>
